#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ProductShipperCollection : BaseTest 
	{

		private BOL.ProductShipperCollection _pscTest;
		private System.Guid _bpGuid;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM ProductShipper WHERE DivisionCode = '" + this.TestDivisionCode + "'");

				this.RefreshData = false;
			}

			this._pscTest = new BOL.ProductShipperCollection(this._bpGuid);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 BloodProductGuid FROM BloodProduct" );
			Guid bloodProductGuid = (Guid)dr[TABLES.ProductShipper.BloodProductGuid];
			//
			BOL.ProductShipperCollection psc = new ProductShipperCollection( bloodProductGuid );
			//
			Assert.IsNotNull( psc );
			Assert.IsTrue( psc.Count > 0 );
		}

		[Test]
		public void Ctor_Guid_Fail()
		{
			BOL.ProductShipperCollection psc = new ProductShipperCollection( Guid.NewGuid() );
			//
			Assert.IsNotNull( psc );
			Assert.IsTrue( psc.Count == 0 );
		}

		[Test]
		public void Add_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			int prevCount = this._pscTest.Count;

			BOL.ProductShipper psNew = new BOL.ProductShipper(tstValue);

			this._pscTest.Add(psNew);

			Assert.AreEqual(prevCount+1, this._pscTest.Count, "Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Add_Fail()
		{
		}

		[Test]
		public void Remove_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			int prevCount = this._pscTest.Count;

			BOL.ProductShipper psNew = new BOL.ProductShipper(tstValue);

			this._pscTest.Add(psNew);
			this._pscTest.Remove(psNew);

			Assert.AreEqual(prevCount, this._pscTest.Count, "Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Remove_Fail()
		{
		}

		[Test]
		public void ActiveShippersCount_Pass()
		{
			DataTable dtCount = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductShipper WHERE BloodProductGuid = '" + this._bpGuid.ToString() + "' AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");

			Assert.AreEqual(dtCount.Rows.Count, this._pscTest.ActiveShippersCount);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ActiveShippersCount_Fail()
		{
		}

		[Test]
		public void this_Pass()
		{
			BOL.ProductShipper tstValue = this._pscTest[0];

			Assert.IsNotNull(tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void this_Fail()
		{
		}

		[Test]
		public void GetElementByLocalSupplierGuid_Pass()
		{
			System.Guid lsGuid = DataCreator.GetRecordGuid("SELECT TOP 1 LocalSupplierGuid FROM ProductShipper WHERE BloodProductGuid = '" + this._bpGuid.ToString() + "' AND DivisionCode = '" + this.TestDivisionCode + "'");

			BOL.ProductShipper tstValue = this._pscTest.GetElementByLocalSupplierGuid(lsGuid);

			Assert.AreEqual(lsGuid, tstValue.LocalSupplierGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetElementByLocalSupplierGuid_Fail()
		{
		}

		[Test]
		public void DoesLocalSupplierExist_Pass()
		{
			System.Guid lsGuid = DataCreator.GetRecordGuid("SELECT TOP 1 LocalSupplierGuid FROM ProductShipper WHERE BloodProductGuid = '" + this._bpGuid.ToString() + "' AND DivisionCode = '" + this.TestDivisionCode + "'");

			bool retValue = this._pscTest.DoesLocalSupplierExist(lsGuid);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DoesLocalSupplierExist_Fail()
		{
		}
	}
}
#endif
